/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;

public class DimensionTypeSync {
    @OnlyIn(value=Dist.CLIENT)
    public static Map<ResourceKey<Level>, ResourceKey<DimensionType>> clientTypeMap;
    @OnlyIn(value=Dist.CLIENT)
    private static RegistryAccess currentDimensionTypeTracker;

    @OnlyIn(value=Dist.CLIENT)
    public static void onGameJoinPacketReceived(RegistryAccess tracker) {
        currentDimensionTypeTracker = tracker;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Map<ResourceKey<Level>, ResourceKey<DimensionType>> typeMapFromTag(CompoundTag tag) {
        HashMap<ResourceKey<Level>, ResourceKey<DimensionType>> result = new HashMap<ResourceKey<Level>, ResourceKey<DimensionType>>();
        tag.m_128431_().forEach(key -> {
            ResourceKey<Level> worldKey = DimId.idToKey(key);
            String val = tag.m_128461_(key);
            ResourceKey typeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation(val));
            result.put(worldKey, typeKey);
        });
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void acceptTypeMapData(CompoundTag tag) {
        clientTypeMap = DimensionTypeSync.typeMapFromTag(tag);
        Helper.log("Received Dimension Type Sync");
        Helper.log("\n" + Helper.myToString(clientTypeMap.entrySet().stream().map(e -> ((ResourceKey)e.getKey()).m_135782_().toString() + " -> " + String.valueOf(((ResourceKey)e.getValue()).m_135782_()))));
    }

    public static CompoundTag createTagFromServerWorldInfo() {
        RegistryAccess.Frozen registryManager = MiscHelper.getServer().m_206579_();
        Registry dimensionTypes = registryManager.m_175515_(Registries.f_256787_);
        return DimensionTypeSync.typeMapToTag(Streams.stream((Iterable)MiscHelper.getServer().m_129785_()).collect(Collectors.toMap(Level::m_46472_, w -> {
            DimensionType dimensionType = w.m_6042_();
            ResourceLocation id = dimensionTypes.m_7981_((Object)dimensionType);
            if (id == null) {
                Helper.err("Missing dim type id for " + String.valueOf(w.m_46472_()));
                Helper.err("Registered dimension types " + Helper.myToString(dimensionTypes.m_6566_().stream()));
                return BuiltinDimensionTypes.f_223538_;
            }
            return DimensionTypeSync.idToDimType(id);
        })));
    }

    public static ResourceKey<DimensionType> idToDimType(ResourceLocation id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)id);
    }

    private static CompoundTag typeMapToTag(Map<ResourceKey<Level>, ResourceKey<DimensionType>> data) {
        CompoundTag tag = new CompoundTag();
        data.forEach((worldKey, typeKey) -> tag.m_128365_(worldKey.m_135782_().toString(), (Tag)StringTag.m_129297_((String)typeKey.m_135782_().toString())));
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceKey<DimensionType> getDimensionTypeKey(ResourceKey<Level> worldKey) {
        ResourceKey<DimensionType> obj = clientTypeMap.get(worldKey);
        if (obj == null) {
            Helper.err("Missing Dimension Type For " + String.valueOf(worldKey.m_135782_()));
            return BuiltinDimensionTypes.f_223538_;
        }
        return obj;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static DimensionType getDimensionType(ResourceKey<DimensionType> registryKey) {
        return (DimensionType)currentDimensionTypeTracker.m_175515_(Registries.f_256787_).m_6246_(registryKey);
    }
}

